/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.challenge.challenges;

import java.util.HashSet;
import java.util.Set;
import me.angel.challenges6t4.challenge.Challenge;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1589;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class CantTouchRedChallenge
extends Challenge {
    private static final Set<class_2248> RED_BLOCKS = new HashSet<class_2248>();
    private static final Set<class_1792> RED_ITEMS = new HashSet<class_1792>();
    private static final Set<class_1299<?>> RED_MOBS = new HashSet();
    private static final double MOB_CHECK_RADIUS = 0.75;
    private boolean explosionMode = false;

    public CantTouchRedChallenge() {
        super("cant_touch_red", (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.cant_touch_red.name"), (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.cant_touch_red.description"), false, Challenge.MultiplayerStatus.EXPERIMENTAL);
    }

    @Override
    public boolean isGameBeatable() {
        return true;
    }

    @Override
    public void onEnable() {
    }

    @Override
    public void onDisable() {
    }

    @Override
    public boolean hasOptions() {
        return true;
    }

    public boolean isRedBlock(class_2248 block) {
        return RED_BLOCKS.contains(block);
    }

    public boolean isRedItem(class_1792 item) {
        if (item instanceof class_1747) {
            class_2248 block = ((class_1747)item).method_7711();
            return this.isRedBlock(block);
        }
        return RED_ITEMS.contains(item);
    }

    public boolean isRedMob(class_1297 entity) {
        if (entity.method_5864() == class_1299.field_6052 || entity.method_5864() == class_1299.field_6044) {
            return false;
        }
        return RED_MOBS.contains(entity.method_5864()) || entity instanceof class_1589 && ((class_1589)entity).method_7152() > 0;
    }

    public boolean isExplosionMode() {
        return this.explosionMode;
    }

    public void setExplosionMode(boolean explosionMode) {
        this.explosionMode = explosionMode;
    }

    private void killPlayer(class_1657 player, String deathType, String targetName) {
        class_1937 class_19372;
        if (this.explosionMode) {
            this.createExplosion(player.method_37908(), player.method_23317(), player.method_23318(), player.method_23321(), 3.0f);
            player.method_7353((class_2561)class_2561.method_43471((String)"challenges6t4.explosion.red_touch"), true);
        } else if (player instanceof class_3222 && (class_19372 = player.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            player.method_64397(serverWorld, serverWorld.method_48963().method_48831(), Float.MAX_VALUE);
            player.method_7353((class_2561)class_2561.method_43469((String)("challenges6t4.death.red_touch." + deathType), (Object[])new Object[]{targetName}), true);
        } else {
            player.method_6033(0.0f);
            player.method_7353((class_2561)class_2561.method_43469((String)("challenges6t4.death.red_touch." + deathType), (Object[])new Object[]{targetName}), true);
        }
    }

    public void createExplosion(class_1937 world, double x, double y, double z, float power) {
        world.method_8537(null, x, y, z, power, true, class_1937.class_7867.field_40891);
    }

    public boolean shouldKillPlayer(class_1657 player) {
        if (!this.isEnabled()) {
            return false;
        }
        class_2338 pos = player.method_24515();
        for (int y = 0; y <= 1; ++y) {
            class_2338 checkPos = pos.method_10086(y);
            class_2248 block = player.method_37908().method_8320(checkPos).method_26204();
            if (!RED_BLOCKS.contains(block)) continue;
            this.killPlayer(player, "block", block.method_9518().getString());
            return true;
        }
        class_2338 standingPos = class_2338.method_49637((double)player.method_23317(), (double)(player.method_23318() - 0.1), (double)player.method_23321());
        class_2248 standingBlock = player.method_37908().method_8320(standingPos).method_26204();
        if (RED_BLOCKS.contains(standingBlock)) {
            this.killPlayer(player, "block", standingBlock.method_9518().getString());
            return true;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7960() || !this.isRedItem(stack.method_7909())) continue;
            this.killPlayer(player, "item", stack.method_7964().getString());
            return true;
        }
        class_238 checkBox = player.method_5829().method_1014(0.75);
        for (class_1297 entity : player.method_37908().method_8335((class_1297)player, checkBox)) {
            if (!this.isRedMob(entity)) continue;
            this.killPlayer(player, "mob", entity.method_5477().getString());
            return true;
        }
        return false;
    }

    public void onAttackRedMob(class_1657 player, class_1297 target) {
        if (this.isEnabled() && this.isRedMob(target)) {
            this.killPlayer(player, "mob_attack", target.method_5477().getString());
        }
    }

    @Override
    public String getShowcaseVideoUrl() {
        return "https://youtu.be/4w1kTuf9TkA";
    }

    static {
        RED_BLOCKS.add(class_2246.field_10559);
        RED_BLOCKS.add(class_2246.field_10240);
        RED_BLOCKS.add(class_2246.field_10270);
        RED_BLOCKS.add(class_2246.field_10449);
        RED_BLOCKS.add(class_2246.field_10430);
        RED_BLOCKS.add(class_2246.field_10164);
        RED_BLOCKS.add(class_2246.field_9986);
        RED_BLOCKS.add(class_2246.field_22422);
        RED_BLOCKS.add(class_2246.field_10375);
        RED_BLOCKS.add(class_2246.field_10036);
        RED_BLOCKS.add(class_2246.field_10534);
        RED_BLOCKS.add(class_2246.field_10344);
        RED_BLOCKS.add(class_2246.field_10624);
        RED_BLOCKS.add(class_2246.field_10420);
        RED_BLOCKS.add(class_2246.field_10413);
        RED_BLOCKS.add(class_2246.field_10359);
        RED_BLOCKS.add(class_2246.field_10336);
        RED_BLOCKS.add(class_2246.field_10099);
        RED_BLOCKS.add(class_2246.field_10260);
        RED_BLOCKS.add(class_2246.field_10536);
        RED_BLOCKS.add(class_2246.field_10058);
        RED_BLOCKS.add(class_2246.field_10287);
        RED_BLOCKS.add(class_2246.field_16330);
        RED_BLOCKS.add(class_2246.field_10504);
        RED_BLOCKS.add(class_2246.field_10485);
        RED_BLOCKS.add(class_2246.field_10314);
        RED_BLOCKS.add(class_2246.field_10328);
        RED_BLOCKS.add(class_2246.field_10383);
        RED_BLOCKS.add(class_2246.field_10272);
        RED_BLOCKS.add(class_2246.field_10118);
        RED_BLOCKS.add(class_2246.field_10536);
        RED_BLOCKS.add(class_2246.field_10068);
        RED_BLOCKS.add(class_2246.field_10406);
        RED_BLOCKS.add(class_2246.field_10279);
        RED_BLOCKS.add(class_2246.field_10069);
        RED_BLOCKS.add(class_2246.field_27140);
        RED_BLOCKS.add(class_2246.field_27157);
        RED_BLOCKS.add(class_2246.field_10002);
        RED_BLOCKS.add(class_2246.field_10080);
        RED_BLOCKS.add(class_2246.field_29030);
        RED_BLOCKS.add(class_2246.field_10091);
        RED_BLOCKS.add(class_2246.field_10523);
        RED_BLOCKS.add(class_2246.field_10301);
        RED_BLOCKS.add(class_2246.field_10524);
        RED_BLOCKS.add(class_2246.field_10377);
        RED_BLOCKS.add(class_2246.field_10450);
        RED_BLOCKS.add(class_2246.field_10515);
        RED_BLOCKS.add(class_2246.field_9974);
        RED_BLOCKS.add(class_2246.field_10541);
        RED_BLOCKS.add(class_2246.field_22121);
        RED_BLOCKS.add(class_2246.field_22125);
        RED_BLOCKS.add(class_2246.field_22118);
        RED_BLOCKS.add(class_2246.field_22119);
        RED_BLOCKS.add(class_2246.field_22505);
        RED_BLOCKS.add(class_2246.field_22506);
        RED_BLOCKS.add(class_2246.field_22120);
        RED_BLOCKS.add(class_2246.field_22126);
        RED_BLOCKS.add(class_2246.field_22128);
        RED_BLOCKS.add(class_2246.field_22098);
        RED_BLOCKS.add(class_2246.field_22132);
        RED_BLOCKS.add(class_2246.field_22096);
        RED_BLOCKS.add(class_2246.field_22102);
        RED_BLOCKS.add(class_2246.field_22094);
        RED_BLOCKS.add(class_2246.field_22130);
        RED_BLOCKS.add(class_2246.field_22100);
        RED_BLOCKS.add(class_2246.field_22104);
        RED_BLOCKS.add(class_2246.field_22106);
        RED_ITEMS.add(class_1802.field_8264);
        RED_ITEMS.add(class_1802.field_8725);
        RED_ITEMS.add(class_1802.field_8530);
        RED_ITEMS.add(class_1802.field_8810);
        RED_ITEMS.add(class_1802.field_8790);
        RED_ITEMS.add(class_1802.field_17517);
        RED_ITEMS.add(class_1802.field_8880);
        RED_ITEMS.add(class_1802.field_17502);
        RED_ITEMS.add(class_1802.field_17527);
        RED_ITEMS.add(class_1802.field_8279);
        RED_ITEMS.add(class_1802.field_16998);
        RED_ITEMS.add(class_1802.field_8597);
        RED_ITEMS.add(class_1802.field_8586);
        RED_ITEMS.add(class_1802.field_8789);
        RED_ITEMS.add(class_1802.field_8482);
        RED_ITEMS.add(class_1802.field_19058);
        RED_ITEMS.add(class_1802.field_8636);
        RED_ITEMS.add(class_1802.field_8879);
        RED_ITEMS.add(class_1802.field_8353);
        RED_ITEMS.add(class_1802.field_8870);
        RED_ITEMS.add(class_1802.field_8197);
        RED_ITEMS.add(class_1802.field_8757);
        RED_ITEMS.add(class_1802.field_8676);
        RED_ITEMS.add(class_1802.field_8046);
        RED_ITEMS.add(class_1802.field_8186);
        RED_ITEMS.add(class_1802.field_8515);
        RED_ITEMS.add(class_1802.field_8680);
        RED_ITEMS.add(class_1802.field_8497);
        RED_ITEMS.add(class_1802.field_8187);
        RED_ITEMS.add(class_1802.field_8748);
        RED_ITEMS.add(class_1802.field_8251);
        RED_MOBS.add(class_1299.field_6102);
        RED_MOBS.add(class_1299.field_23214);
        RED_MOBS.add(class_1299.field_6132);
        RED_MOBS.add(class_1299.field_6143);
        RED_MOBS.add(class_1299.field_6073);
        RED_MOBS.add(class_1299.field_6079);
        RED_MOBS.add(class_1299.field_6084);
        RED_MOBS.add(class_1299.field_42622);
        RED_MOBS.add(class_1299.field_6114);
        RED_MOBS.add(class_1299.field_6054);
    }
}

